/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth.util;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.config.AbstractNodeConfigBean;
import com.ibm.hwmca.ui.bonsai.config.BonsaiConfigException;
import com.ibm.hwmca.ui.bonsai.config.WorkareaConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BonsaiRegurgitater {
    private static final String TRACEMASK_T = "XBUIREGT";
    private static final String TRACEMASK_F = "XBUIREGF";
    private static final String TRACEMASK_D = "XBUIREGD";

    private BonsaiRegurgitater() {
    }

    public static List getTrees(List rootNodeIds, Map configBeans, BonsaiTreeNode parent) throws BonsaiConfigException {
        Trace.trace(TRACEMASK_T, "--> BonsaiRegurgitater.getTrees(" + rootNodeIds + ", [configBeans], " + parent + ")");
        AbstractNodeConfigBean configBean = null;
        WorkareaConfigBean subtreeWorkarea = null;
        Object str = null;
        HashSet subtreeFilters = new HashSet();
        for (BonsaiTreeNode ancestor = parent; ancestor != null; ancestor = ancestor.getParent()) {
            configBean = ancestor.getConfigBean();
            if (subtreeWorkarea == null) {
                subtreeWorkarea = configBean.getSubtreeWorkarea();
            }
            subtreeFilters.addAll(configBean.getSubtreeFilters());
        }
        TreeRegurgitater regurgitater = new TreeRegurgitater(configBeans);
        ArrayList rootNodes = new ArrayList();
        Iterator i = rootNodeIds.iterator();
        while (i.hasNext()) {
            rootNodes.addAll(regurgitater.getTreeNodes((String)i.next(), parent, subtreeWorkarea, subtreeFilters));
        }
        Trace.trace(TRACEMASK_D, rootNodes.size() + " root nodes created and returned");
        Trace.trace(TRACEMASK_T, "<-- BonsaiRegurgitater.getTrees()");
        return rootNodes;
    }

    private static class TreeRegurgitater {
        private Map nodeMap;

        private TreeRegurgitater(Map nodeMap) {
            Trace.trace(BonsaiRegurgitater.TRACEMASK_D, "<> BonsaiRegurgitater.TreeRegurgitater(" + nodeMap + ")");
            this.nodeMap = nodeMap;
        }

        private List getTreeNodes(String nodeKey, BonsaiTreeNode parent, WorkareaConfigBean subtreeWorkarea, Set subtreeFilters) throws BonsaiConfigException {
            Trace.trace(BonsaiRegurgitater.TRACEMASK_D, "<> BonsaiRegurgitater.TreeRegurgitater.getTreeNodes(" + nodeKey + ", " + parent + ", " + subtreeWorkarea + ", " + subtreeFilters + ")");
            AbstractNodeConfigBean bean = (AbstractNodeConfigBean)this.nodeMap.get(nodeKey);
            if (bean == null) {
                throw new BonsaiConfigException("The node " + nodeKey + " is not defined in the XML!");
            }
            HashSet filters = new HashSet(subtreeFilters);
            filters.addAll(bean.getFilters());
            List nodes = bean.getTreeNodes(parent, subtreeWorkarea, filters);
            WorkareaConfigBean childsSubtreeWorkarea = bean.getSubtreeWorkarea();
            if (childsSubtreeWorkarea == null) {
                childsSubtreeWorkarea = subtreeWorkarea;
            }
            filters = new HashSet(subtreeFilters);
            filters.addAll(bean.getSubtreeFilters());
            BonsaiTreeNode node = null;
            Iterator i = nodes.iterator();
            while (i.hasNext()) {
                node = (BonsaiTreeNode)i.next();
                Iterator childKeys = bean.getChildren().iterator();
                while (childKeys.hasNext()) {
                    node.addChildren(this.getTreeNodes((String)childKeys.next(), node, childsSubtreeWorkarea, filters));
                }
            }
            return nodes;
        }
    }
}

